# Универсальные функции
## Общее
Из xdto пакета автоматически распознаются **только** типы:
- строка
- число
- булево  
> Все остальное нужно обрабатывать!
## Контекст
Структура с различными параметрамми и данными для обработки объекта.
## Инициализировать контекст записи объекта
```
ВыполнитьФункцию("ИнициализироватьКонтекстЗаписиОбъекта", Контекст);
```
## НайтиСоздатьОбъект
## ЗаполнитьОбъект
## ЗаписатьОбъект
## ОбработатьИсключениеПриЗаписиОбъекта

# Методы схем
## Получение свойст
``` C+
ДоговорЕРП = (bool) InitMessage.Properties.GetProperty("ДоговорЕРП").GetValue();
ДоговорУТ = (bool) InitMessage.Properties.GetProperty("ДоговорУТ").GetValue();
ДоговорДО = (bool) InitMessage.Properties.GetProperty("ДоговорДО").GetValue();
ДоговорБСО = (bool) InitMessage.Properties.GetProperty("ДоговорБСО").GetValue();
```

# Трансформации
## Пример
```
ВтДокументПоступлениеТоваровУслуг.Дата = ДокументИмпПриемкаСтроительныхРаботУслуг.Дата;
ВтДокументПоступлениеТоваровУслуг.ПометкаУдаления = ДокументИмпПриемкаСтроительныхРаботУслуг.ПометкаУдаления;
ВтДокументПоступлениеТоваровУслуг.Проведен = ДокументИмпПриемкаСтроительныхРаботУслуг.Проведен;
ВтДокументПоступлениеТоваровУслуг.ДатаВходящегоДокумента = ДокументИмпПриемкаСтроительныхРаботУслуг.ДатаВходящегоДокумента;
ВтДокументПоступлениеТоваровУслуг.Комментарий = ДокументИмпПриемкаСтроительныхРаботУслуг.Комментарий;
ВтДокументПоступлениеТоваровУслуг.КратностьВзаиморасчетов = ДокументИмпПриемкаСтроительныхРаботУслуг.КратностьВзаиморасчетов;
ВтДокументПоступлениеТоваровУслуг.КурсВзаиморасчетов = ДокументИмпПриемкаСтроительныхРаботУслуг.КурсВзаиморасчетов;
ВтДокументПоступлениеТоваровУслуг.НДСВключенВСтоимость = ДокументИмпПриемкаСтроительныхРаботУслуг.НДСВключенВСтоимость;
ВтДокументПоступлениеТоваровУслуг.НомерВходящегоДокумента = ДокументИмпПриемкаСтроительныхРаботУслуг.НомерВходящегоДокумента;
ВтДокументПоступлениеТоваровУслуг.СуммаВключаетНДС = ДокументИмпПриемкаСтроительныхРаботУслуг.СуммаВключаетНДС;
ВтДокументПоступлениеТоваровУслуг.РучнаяКорректировка = ДокументИмпПриемкаСтроительныхРаботУслуг.РучнаяКорректировка;
ВтДокументПоступлениеТоваровУслуг.ЕстьРасхождения = ДокументИмпПриемкаСтроительныхРаботУслуг.ЕстьРасхождения;
ВтДокументПоступлениеТоваровУслуг.СуммаВключаетНДС = ДокументИмпПриемкаСтроительныхРаботУслуг.СуммаВключаетНДС;
ВтДокументПоступлениеТоваровУслуг.ЭтоУниверсальныйДокумент = ДокументИмпПриемкаСтроительныхРаботУслуг.ЭтоУниверсальныйДокумент;
ВтДокументПоступлениеТоваровУслуг.СуммаГарантийногоУдержания = ДокументИмпПриемкаСтроительныхРаботУслуг.СуммаГарантийногоУдержания;
ВтДокументПоступлениеТоваровУслуг.Д_СуммаЗачетенныхАвансов = ДокументИмпПриемкаСтроительныхРаботУслуг.Д_СуммаЗачетенныхАвансов;
ВтДокументПоступлениеТоваровУслуг.Д_СуммаВозмещаемыхУслуг_Общая = ДокументИмпПриемкаСтроительныхРаботУслуг.Д_СуммаВозмещаемыхУслуг;

CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.ВалютаДокумента, ВтДокументПоступлениеТоваровУслуг.ВалютаДокумента);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.ДоговорКонтрагента, ВтДокументПоступлениеТоваровУслуг.ДоговорКонтрагента);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.Контрагент, ВтДокументПоступлениеТоваровУслуг.Контрагент);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.Организация, ВтДокументПоступлениеТоваровУслуг.Организация);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.Ответственный, ВтДокументПоступлениеТоваровУслуг.Ответственный);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.СчетУчетаРасчетовПоАвансам, ВтДокументПоступлениеТоваровУслуг.СчетУчетаРасчетовПоАвансам);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.СчетУчетаРасчетовСКонтрагентом, ВтДокументПоступлениеТоваровУслуг.СчетУчетаРасчетовСКонтрагентом);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.Грузоотправитель, ВтДокументПоступлениеТоваровУслуг.Грузоотправитель);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.Грузополучатель, ВтДокументПоступлениеТоваровУслуг.Грузополучатель);
CommonFunctions.CopyMatchingProperties(ДокументИмпПриемкаСтроительныхРаботУслуг.СчетУчетаРасчетовПоТаре, ВтДокументПоступлениеТоваровУслуг.СчетУчетаРасчетовПоТаре);

foreach (var Element in ДокументИмпПриемкаСтроительныхРаботУслуг.Услуги) {
    var NewElement = ВтДокументПоступлениеТоваровУслуг.Услуги.AddElement();

    CommonFunctions.CopyMatchingProperties(Element, NewElement);

    CommonFunctions.CopyMatchingProperties(Element.СчетЗатрат, NewElement.СчетЗатрат);
    CommonFunctions.CopyMatchingProperties(Element.СчетЗатратНУ, NewElement.СчетЗатратНУ);
    CommonFunctions.CopyMatchingProperties(Element.Субконто1, NewElement.Субконто1);
    CommonFunctions.CopyMatchingProperties(Element.Субконто2, NewElement.Субконто2);
    CommonFunctions.CopyMatchingProperties(Element.Субконто3, NewElement.Субконто3);
    CommonFunctions.CopyMatchingProperties(Element.СчетУчетаНДС, NewElement.СчетУчетаНДС);
    
    
}

foreach (var Element in ДокументИмпПриемкаСтроительныхРаботУслуг.ЗачетАвансов) {
    var NewElement = ВтДокументПоступлениеТоваровУслуг.ЗачетАвансов.AddElement();
    NewElement.СуммаЗачета = Element.СуммаЗачета;
}    
```
# Обработчики
## Эталонный отправки из платформ в 1с
```
Попытка
    НачатьТранзакцию();
    
    Контекст = Новый Структура;
    Контекст.Вставить("ЭтотОбъект", ЭтотОбъект);

    ВыполнитьФункцию("ИнициализироватьКонтекстЗаписиОбъекта", Контекст);

    ВыполнитьФункцию("НайтиСоздатьОбъект", Контекст);

    ВыполнитьФункцию("ЗаполнитьОбъект", Контекст);

    ВыполнитьФункцию("ЗаписатьОбъект", Контекст);

    ЗафиксироватьТранзакцию();
    
Исключение
    Если ТранзакцияАктивна() Тогда
        ОтменитьТранзакцию();
    КонецЕсли;
    
    Контекст.Вставить("ИнформацияОбОшибке", ИнформацияОбОшибке());
    ВыполнитьФункцию("ОбработатьИсключениеПриЗаписиОбъекта", Контекст);
    
КонецПопытки;
```
## Расширение функционала универсальных функций
### Сначала документ записывается, затем проводится если был проведен
```
Если ЗагружаемыйОбъект.Проведен Тогда
  Контекст.Вставить("РежимЗаписи", РежимЗаписиДокумента.Проведение);	
КонецЕсли;
```
### Удобное встраивание вместо БА
```
ЗагружаемыйОбъект = Контекст.ЗаписываемыйОбъект;
ПреобразованнаяСтруктура = Контекст.ПреобразованныеДанные[0]; 
```
### Поиск значений
```
ПараметрыПоиска = ОбщегоНазначения.СкопироватьРекурсивно(Контекст);

// СчетКапВложенийБУ 
ИмяПоляИсточник 	= "СчетЗатрат";  
ИмяПоляПриемник 	= "СчетКапВложенийБУ"; 
ОписаниеТипа 		= Новый ОписаниеТипов("ПланСчетовСсылка.Хозрасчетный"); 
ЗначениеСвойства 	= ОбщегоНазначенияКлиентСервер.СвойствоСтруктуры(СтрокаУслуги, ИмяПоляИсточник);
ЗначениеСвойстваВ1с = ВыполнитьФункцию("ЗначениеРеквизита", ЗначениеСвойства, ОписаниеТипа, ПараметрыПоиска, ИмяПоляИсточник); 
СтрокаЗатраты[ИмяПоляПриемник] = ЗначениеСвойстваВ1с; 

```
# Примеры
## Создание нескольких типов в обработчике отправки в 1с
```
Попытка
    НачатьТранзакцию();
    
    Контекст = Новый Структура;
    Контекст.Вставить("ЭтотОбъект", ЭтотОбъект);

    ВыполнитьФункцию("ИнициализироватьКонтекстЗаписиОбъекта", Контекст);

    Контекст.Вставить("ЗаписываемыйОбъект", ВыполнитьФункцию("НайтиКонтрагентаПоКонтексту", Контекст));
    
    ВыполнитьФункцию("НайтиСоздатьОбъект", Контекст);

    ВыполнитьФункцию("ЗаполнитьОбъект", Контекст);
    
    КонтекстПартнера = Новый Структура;
    КонтекстПартнера.Вставить("ТипДанных", "Справочник.Партнеры");
    КонтекстПартнера.Вставить("ЭтотОбъект", ЭтотОбъект);

    ВыполнитьФункцию("ИнициализироватьКонтекстЗаписиОбъекта", КонтекстПартнера);

    КонтекстПартнера.ПреобразованныеДанные[0].Идентификатор = XMLСтрока(Новый УникальныйИдентификатор);

    Если ЗначениеЗаполнено(Контекст.ЗаписываемыйОбъект.Партнер) Тогда
        КонтекстПартнера.Вставить("ЗаписываемыйОбъект", Контекст.ЗаписываемыйОбъект.Партнер.ПолучитьОбъект());
    КонецЕсли;
    
    ВыполнитьФункцию("НайтиСоздатьОбъект", КонтекстПартнера);

    ВыполнитьФункцию("ЗаполнитьОбъект", КонтекстПартнера);

    КонтекстПартнера.ЗаписываемыйОбъект.Клиент = Истина;
    КонтекстПартнера.ЗаписываемыйОбъект.Поставщик = Истина;
    КонтекстПартнера.ЗаписываемыйОбъект.ПрочиеОтношения = Истина;
    
    ВыполнитьФункцию("ЗаписатьОбъект", КонтекстПартнера);

    Если Не ЗначениеЗаполнено(Контекст.ЗаписываемыйОбъект.Партнер) Тогда
        Контекст.ЗаписываемыйОбъект.Партнер = КонтекстПартнера.ЗаписываемыйОбъект.Ссылка;
    КонецЕсли;

    Если ЗначениеЗаполнено(Контекст.ЗаписываемыйОбъект.Партнер) Тогда
        ПартнерыИКонтрагенты.ЗаписатьИерархиюПартнера(Контекст.ЗаписываемыйОбъект.Партнер);
    КонецЕсли;

    СтруктураОбъекта = КонтекстПартнера.ПреобразованныеДанные[0];
    Если Контекст.ЗаписываемыйОбъект.ЮридическоеФизическоеЛицо = Перечисления.ЮридическоеФизическоеЛицо.ЮридическоеЛицо
        И Контекст.ЗаписываемыйОбъект.СтранаРегистрации = Справочники.СтраныМира.Россия Тогда

        Контекст.ЗаписываемыйОбъект.ЮрФизЛицо = Перечисления.ЮрФизЛицо.ЮрЛицо;
        
    ИначеЕсли Контекст.ЗаписываемыйОбъект.ЮридическоеФизическоеЛицо = Перечисления.ЮридическоеФизическоеЛицо.ЮридическоеЛицо
        И Контекст.ЗаписываемыйОбъект.СтранаРегистрации <> Справочники.СтраныМира.Россия Тогда

        Контекст.ЗаписываемыйОбъект.ЮрФизЛицо = Перечисления.ЮрФизЛицо.ЮрЛицоНеРезидент;

    ИначеЕсли Контекст.ЗаписываемыйОбъект.ЮридическоеФизическоеЛицо = Перечисления.ЮридическоеФизическоеЛицо.ФизическоеЛицо
        И ОбщегоНазначенияКлиентСервер.СвойствоСтруктуры(СтруктураОбъекта, "ИндивидуальныйПредприниматель") <> Истина Тогда

        Контекст.ЗаписываемыйОбъект.ЮрФизЛицо = Перечисления.ЮрФизЛицо.ФизЛицо;

    ИначеЕсли Контекст.ЗаписываемыйОбъект.ЮридическоеФизическоеЛицо = Перечисления.ЮридическоеФизическоеЛицо.ФизическоеЛицо
        И ОбщегоНазначенияКлиентСервер.СвойствоСтруктуры(СтруктураОбъекта, "ИндивидуальныйПредприниматель") = Истина Тогда

        Контекст.ЗаписываемыйОбъект.ЮрФизЛицо = Перечисления.ЮрФизЛицо.ИндивидуальныйПредприниматель;

    КонецЕсли;

    Контекст.ЗаписываемыйОбъект.ДополнительныеСвойства.Вставить("ИгнорироватьКонтрольИНН");
    Контекст.ЗаписываемыйОбъект.ДополнительныеСвойства.Вставить("ОтключитьМеханизмРегистрацииОбъектов");

    ВыполнитьФункцию("ЗаписатьОбъект", Контекст);

    ЗафиксироватьТранзакцию();
    
Исключение
    Если ТранзакцияАктивна() Тогда
        ОтменитьТранзакцию();
    КонецЕсли;
    
    Контекст.Вставить("ИнформацияОбОшибке", ИнформацияОбОшибке());
    ВыполнитьФункцию("ОбработатьИсключениеПриЗаписиОбъекта", Контекст);
    
КонецПопытки;

```